function [data] = rcombine(dir_tmp)
%This combines all regions of one session into one dataset.
%Synatax:   [data] = rcombine();
%Input:     dir_tmp = the directory of interest
%Output:    data = the combined data

%currently not oupt put really
data = [];

%where are the files?
if nargin==0
    dir_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end

%one level down
dir_two = dir(dir_tmp); %regions.

out_root = [dir_tmp,slash,'R_all',slash];   %make the output directory structure root
mkdir(out_root);         %create the output root.
%the file types you will see
types = {'flat','prop','vert','3Dvert','aflat','aprop','avert','a3Dvert','rotated','arotated'};
vtime = 1;  %first time marker
h2 = waitbar(0,'Processing Dir:');    %initialize progress bar.
for j = 3:size(dir_two,1)
    waitbar((j-2)/(size(dir_two,1)-2),h2,['Processing Dir: ' dir_two(j).name]);   %update progress
    if dir_two(j).isdir
        dir_three = dir([dir_tmp,slash,dir_two(j).name]);   %The end level
        dir_tmp2 = [dir_tmp,slash,dir_two(j).name,slash];
        if vtime
            %create filename holders
            flat = cell(size(dir_three,1),1);
            prop = cell(size(dir_three,1),1);
            aflat = cell(size(dir_three,1),1);
            aprop = cell(size(dir_three,1),1);
            rotated = cell(size(dir_three,1),1);
            vert = cell(size(dir_three,1),1);
            dvert = cell(size(dir_three,1),1);
            avert = cell(size(dir_three,1),1);
            a3dvert = cell(size(dir_three,1),1);
            arotated = cell(size(dir_three,1),1);
        end
        for k = 3:size(dir_three,1)     %one more level down
            dir_curr = dir([dir_tmp2,slash,dir_three(k).name]);   %The end level
            dir_tmp3 = [dir_tmp2,slash,dir_three(k).name,slash];
            %now setup the out put directory structure
            if vtime    %do this only on the first round
                warning 'off'   %set it off so no annoying chirps for creating a directory
                mkdir(out_root,dir_three(k).name);    %create the root folder for this syn class
                out_flat{k} = [out_root,dir_three(k).name,slash,'flat',slash];
                mkdir(out_flat{k});
                out_prop{k} = [out_root,dir_three(k).name,slash,'prop',slash];
                mkdir(out_prop{k});
                out_aflat{k} = [out_root,dir_three(k).name,slash,'aflat',slash];
                mkdir(out_aflat{k});
                out_aprop{k} = [out_root,dir_three(k).name,slash,'aprop',slash];
                mkdir(out_aprop{k});
                out_rotated{k} = [out_root,dir_three(k).name,slash,'rotated',slash];
                mkdir(out_rotated{k});
                out_vert{k} = [out_root,dir_three(k).name,slash,'vert',slash];
                mkdir(out_vert{k});
                out_dvert{k} = [out_root,dir_three(k).name,slash,'3Dvert',slash];
                mkdir(out_dvert{k});
                out_avert{k} = [out_root,dir_three(k).name,slash,'avert',slash];
                mkdir(out_avert{k});
                out_a3dvert{k} = [out_root,dir_three(k).name,slash,'a3Dvert',slash];
                mkdir(out_a3dvert{k});
                out_arotated{k} = [out_root,dir_three(k).name,slash,'arotated',slash];
                mkdir(out_arotated{k});
                warning 'on'    %back on
            end
            %we only care about the files now.
            if size(dir_curr,1)>2   %lets make sure the directory acutally has files in it.
                [flat_tmp,prop_tmp,aflat_tmp,aprop_tmp,rotated_tmp,vert_tmp,dvert_tmp,...
                    avert_tmp,a3dvert_tmp,arotated_tmp] = process_files(dir_curr);     %get the files we want to move
                %create out dir tmp
                for n = 1:size(flat_tmp,2) %go through files and copy them to new destinations
                    copyfile([dir_tmp3,flat_tmp{n}],[out_flat{k},num2str(j-2),'_',flat_tmp{n}]);
                end
                for o = 1:size(prop_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,prop_tmp{o}],[out_prop{k},num2str(j-2),'_',prop_tmp{o}]);
                end
                for n = 1:size(aflat_tmp,2) %go through files and copy them to new destinations
                    copyfile([dir_tmp3,aflat_tmp{n}],[out_aflat{k},num2str(j-2),'_',aflat_tmp{n}]);
                end
                for o = 1:size(aprop_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,aprop_tmp{o}],[out_aprop{k},num2str(j-2),'_',aprop_tmp{o}]);
                end
                for o = 1:size(rotated_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,rotated_tmp{o}],[out_rotated{k},num2str(j-2),'_',rotated_tmp{o}]);
                end
                for o = 1:size(vert_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,vert_tmp{o}],[out_vert{k},num2str(j-2),'_',vert_tmp{o}]);
                end
                for n = 1:size(dvert_tmp,2) %go through files and copy them to new destinations
                    copyfile([dir_tmp3,dvert_tmp{n}],[out_dvert{k},num2str(j-2),'_',dvert_tmp{n}]);
                end
                for o = 1:size(avert_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,avert_tmp{o}],[out_avert{k},num2str(j-2),'_',avert_tmp{o}]);
                end
                for n = 1:size(a3dvert_tmp,2) %go through files and copy them to new destinations
                    copyfile([dir_tmp3,a3dvert_tmp{n}],[out_a3dvert{k},num2str(j-2),'_',a3dvert_tmp{n}]);
                end
                for o = 1:size(arotated_tmp,2) %no copy over the properties files
                    copyfile([dir_tmp3,arotated_tmp{o}],[out_arotated{k},num2str(j-2),'_',arotated_tmp{o}]);
                end
                %store the file names away
                if ~isempty(flat_tmp)
                    flat_tmp = char(flat_tmp);  %make into character array
                    flat_tmp = [num2str(repmat(j-2,size(flat_tmp,1),1)) repmat('_',size(flat_tmp,1),1) flat_tmp];     %append renaming
                    flat_tmp = cellstr(flat_tmp);   %convert back to cell array
                    flat{k} = vertcat(flat{k},flat_tmp);    %append
                end
                prop_tmp = char(prop_tmp);
                prop_tmp = [num2str(repmat(j-2,size(prop_tmp,1),1)) repmat('_',size(prop_tmp,1),1) prop_tmp];
                prop_tmp = cellstr(prop_tmp);
                prop{k} = vertcat(prop{k},prop_tmp);
                if ~isempty(aflat_tmp)
                    aflat_tmp = char(aflat_tmp);
                    aflat_tmp = [num2str(repmat(j-2,size(aflat_tmp,1),1)) repmat('_',size(aflat_tmp,1),1) aflat_tmp];
                    aflat_tmp = cellstr(aflat_tmp);
                    aflat{k} = vertcat(aflat{k},aflat_tmp);
                end
                aprop_tmp = char(aprop_tmp);
                aprop_tmp = [num2str(repmat(j-2,size(aprop_tmp,1),1)) repmat('_',size(aprop_tmp,1),1) aprop_tmp];
                aprop_tmp = cellstr(aprop_tmp);
                aprop{k} = vertcat(aprop{k},aprop_tmp);
                if ~isempty(rotated_tmp)
                    rotated_tmp = char(rotated_tmp);
                    rotated_tmp = [num2str(repmat(j-2,size(rotated_tmp,1),1)) repmat('_',size(rotated_tmp,1),1) rotated_tmp];
                    rotated_tmp = cellstr(rotated_tmp);
                    rotated{k} = vertcat(rotated{k},rotated_tmp);
                end
                vert_tmp = char(vert_tmp);
                vert_tmp = [num2str(repmat(j-2,size(vert_tmp,1),1)) repmat('_',size(vert_tmp,1),1) vert_tmp];
                vert_tmp = cellstr(vert_tmp);
                vert{k} = vertcat(vert{k},vert_tmp);
                dvert_tmp = char(dvert_tmp);
                dvert_tmp = [num2str(repmat(j-2,size(dvert_tmp,1),1)) repmat('_',size(dvert_tmp,1),1) dvert_tmp];
                dvert_tmp = cellstr(dvert_tmp);
                dvert{k} = vertcat(dvert{k},dvert_tmp);
                avert_tmp = char(avert_tmp);
                avert_tmp = [num2str(repmat(j-2,size(avert_tmp,1),1)) repmat('_',size(avert_tmp,1),1) avert_tmp];
                avert_tmp = cellstr(avert_tmp);
                avert{k} = vertcat(avert{k},avert_tmp);
                if ~isempty(a3dvert_tmp)
                    a3dvert_tmp = char(a3dvert_tmp);
                    a3dvert_tmp = [num2str(repmat(j-2,size(a3dvert_tmp,1),1)) repmat('_',size(a3dvert_tmp,1),1) a3dvert_tmp];
                    a3dvert_tmp = cellstr(a3dvert_tmp);
                    a3dvert{k} = vertcat(a3dvert{k},a3dvert_tmp);
                end
                if ~isempty(arotated_tmp)
                    arotated_tmp = char(arotated_tmp);
                    arotated_tmp = [num2str(repmat(j-2,size(arotated_tmp,1),1)) repmat('_',size(arotated_tmp,1),1) arotated_tmp];
                    arotated_tmp = cellstr(arotated_tmp);
                    arotated{k} = vertcat(arotated{k},arotated_tmp);
                end
            end
        end
        vtime = 0;  %not the first time anymore
    end
end
close(h2);   %close progress bar
%now that everything is moved out to its own directory, join them and save
%to the root.
warning 'off'
h = waitbar(0,'Processing Dir:');    %initialize progress bar.
for l = 3:size(dir_three,1)     %one more level down
    waitbar((l-2)/(size(dir_three,1)-2),h,['Processing Dir: ' dir_three(l).name]);   %update progress
    %the types of files, don't forget sum and asum is with prop and aprop, and
    %count, alluniquecount, allcount is with vert and avert
    files = {flat{l},prop{l},vert{l},dvert{l},aflat{l},aprop{l},avert{l},a3dvert{l},rotated{l},arotated{l}};
    file_dir = {out_flat{l},out_prop{l},out_vert{l},out_dvert{l},out_aflat{l},out_aprop{l},out_avert{l},...
        out_a3dvert{l},out_rotated{l},out_arotated{l}};
    dir_tmp4 = [out_root,dir_three(l).name,slash];
    for i = 1:size(types,2)  %go through the types
        if ~isempty(files{i})&&~isempty(files{i}{1})    %make sure that there are actually files for this type
            switch types{i}
                case {'prop','aprop'}
                    %first join the properties
                    [data] = join_verts_loco(files{i},file_dir{i},dir_tmp4,types{i});
                    %now create the properties files
                    switch types{i}
                        case {'prop'}
                            prop_sum_loco(data,dir_tmp4,0);
                        case {'aprop'}
                            prop_sum_loco(data,dir_tmp4,1);
                    end
                case {'vert','avert'}
                    %first join the vertices
                    [data] = join_verts_loco(files{i},file_dir{i},dir_tmp4,types{i});
                    %go through the data
                    count = []; %initialize
                    acount = [];
                    aucount = [];
                    %pull the names of the channels
                    celllabels = data(1).names;
                    switch types{i}     %vertices and all vertices are treated slightly differently
                        case {'vert'}
                            for m = 1:size(data,2)
                                count(m) = size(data(m).data,1);   %get the number of vertices for each channel
                            end
                            data_tmp = dataset(count','ObsNames',celllabels,'VarNames',{'count'});
                            sav2csv(data_tmp,'count_summary.csv',dir_tmp4);
                        case {'avert'}
                            for m = 1:size(data,2)
                                acount(m) = size(data(m).data,1);    %do the same for the all data
                                aucount(m) = size(unique(data(m).data,'rows'),1);   %get the unique count from all data
                            end
                            data_tmp = dataset(acount','ObsNames',celllabels,'VarNames',{'count'});
                            sav2csv(data_tmp,'allcount_summary.csv',dir_tmp4);
                            data_tmp = dataset(aucount','ObsNames',celllabels,'VarNames',{'count'});
                            sav2csv(data_tmp,'alluniquecount_summary.csv',dir_tmp4);
                    end
                otherwise
                    %if ~isempty(files{i}{1})    %make sure that there are actually files for this type
                    join_verts_loco(files{i},file_dir{i},dir_tmp4,types{i});
                    %end
            end
        end
        %remove the directory
        rmdir(file_dir{i},'s');
    end
end
close(h);   %close progress bar
warning 'on'

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [flat,prop,aflat,aprop,rotated,vert,dvert,avert,a3dvert,arotated] = process_files(dir_struct)

for i = 3:size(dir_struct,1)    %go through the
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
try
    list = names(~idx);
catch
    keyboard
end
%filter for only the files we want
flat_idx = ones(size(list));   %create an index for selecting the flat files
prop_idx = ones(size(list));   %same for prop
aflat_idx = ones(size(list));   %create an index for selecting the flat files
aprop_idx = ones(size(list));   %same for prop
vert_idx = ones(size(list));   %create an index for selecting the flat files
avert_idx = ones(size(list));   %same for prop
dvert_idx = ones(size(list));   %same for prop
a3dvert_idx = ones(size(list)); 
rotated_idx = ones(size(list));   %same for prop
arotated_idx = ones(size(list));   %same for prop
for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    if ~strcmp('flat',list{j}(1:4))
        flat_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('prop',list{j}(1:4))
        prop_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('aflat',list{j}(1:5))
        aflat_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('aprop',list{j}(1:5))
        aprop_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('rotat',list{j}(1:5))  %rotated
        rotated_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('vert_',list{j}(1:5))
        vert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('3Dver',list{j}(1:5))
        dvert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('avert',list{j}(1:5)) %allcount
        avert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('a3Dve',list{j}(1:5))  %alluniquecount
        a3dvert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('arota',list{j}(1:5))  %rotated
        arotated_idx(j) = 0;    %set this for removal
    end
end
%create the desired lists of file names.
flat = list(logical(flat_idx));    %list for flat vertices files
prop = list(logical(prop_idx));    %list for prop files
aflat = list(logical(aflat_idx));    %list for flat vertices files
aprop = list(logical(aprop_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
rotated = list(logical(rotated_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
vert = list(logical(vert_idx));   
dvert = list(logical(dvert_idx));   
avert = list(logical(avert_idx));    
a3dvert = list(logical(a3dvert_idx));   
arotated = list(logical(arotated_idx));

% flat(logical(flat_idx)) = [];   %remove
% prop(logical(prop_idx)) = [];   %gone

%-----------------------------------------------------------------------------------------------------------------------------
function [filenames,uq_names] = dir_sort(filename_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
%truncate the first two rows which are . and ..
%filename_tmp = filename_tmp(3:end,:);
strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
strmask2 = filename_tmp=='&';       %we are going to exempt the & character
strmask = strmask-strmask2;     %removed
for i = 1:size(filename_tmp,1)      %step through each filename and pull the wanted word
    [x,y] = find(strmask(i,:)==1);  %get the positions
    l1 = 0;     %set bookends
    l2 = 1;
    tmp = filename_tmp(i,y(end-1)+1:y(end)-1);    %create an array of the words
    while ~isempty(str2num(tmp))    %lets get to the name and not just the numbers
        l1 = l1+1;
        l2 = l2+1;
        tmp = filename_tmp(i,y(end-l2)+1:y(end-l1)-1);    %create an array of the words
    end
    if size(y,2)<=3
        f_tmp{i,:} = tmp;
    else    %too complicated take the whole thing
        f_tmp{i,:} = filename_tmp(i,y(2)+1:y(end-l1)-1);
    end
end
uq_names = unique(f_tmp);    %how many unique words are there
%make sure there are no duplicates with different cases
idx = [];   %index of removal
for l = 1:size(uq_names,1)      %step through unique names
    for m = 1:size(uq_names,1)     %step through the all file names
        if strcmpi(uq_names(l,:),uq_names(m,:)) && l<m    %if there is a match (case insensitive now) Remove
            idx = [idx;m];  %remove
        end
    end
end 
uq_names(unique(idx),:) = [];    %remove
for j = 1:size(uq_names,1)      %step through unique names
    tmp = [];
    for k = 1:size(f_tmp,1)     %step through the all file names
        if strcmpi(uq_names(j,:),f_tmp(k,:)) %if there is a match (case insensitive now)
            tmp = vertcat(tmp,filename_tmp(k,:));  %put it in the current file names temp
        end
    end
    filenames{j} = tmp;
end            

%-----------------------------------------------------------------------------------------------------------------------------
function [output] = join_verts_loco(file_tmp,dir_tmp,dir_root,cap_str)
%Local version of join verts that does things a little differently
%dir_tmp is where the files are.  dir_root is the level above dir_tmp.
%cap_str is the initial string of the file
[filenames,names] = dir_sort(char(file_tmp));    %convert cell string arry to string array
%Now open each file append and save
mkdir(dir_root);
for j = 1:size(filenames,2) %go through the file sets
    filename_tmp = filenames{j};
    data = [];  %initialize/reset
    verti_tmp = [];
    for i = 1:size(filename_tmp,1)      %now append the files
        %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
        try %make sure the file is not empty
            verti_tmp = single(dlmread([dir_tmp,filename_tmp(i,:)],',',1,0));
            data = vertcat(data,verti_tmp);       %join all the opened data together
        end
    end
    %now save out the data file
    dataout = dataset(data);
    sav2csv(dataout,[cap_str,'_',names{j,1},'_',num2str(size(data,1)),'.csv'],dir_root);
    output(j).data = data;
end
output(1).names = names;

%-----------------------------------------------------------------------------------------------------------------------------
function [cdata] = prop_sum_loco(data,dir_root,all,idx)
%Local function for generated property summary files
%Synatax:   [cdata] = prop_sum2(); 
%Input:     idx = the location of the index property.  default = 2
%           data = the data to be summarized
%           name = the name of the files
%           dir_root = the path where the files are saved
%           all = whether this is all or not, 1 = all, 0 = not
%Output:    cdata = the array of results from the math applied to data.

name = data(1).names;   %pull it out here
%Go through the data.
for i = 1:size(data,2)
    data_tmp = data(i).data;
    %now remove our NaN
    if ~isempty(data_tmp)       %make sure the file actually have data
        data_tmp(isnan(data_tmp(:,1)),:) = [];
        if nargin<4     %the idx is not entered
            idx = sum(data_tmp(:,:));    %grab the first few point for a little test, we pick 5, because changes low that all 5 are not deci
            idx_int = round(idx);   %convert to integer, the size meteric should be the only integer in the lot
            idx_tmp = idx==idx_int;     %where is the int?
            idx_tmp = idx_tmp+(median(data_tmp,1)<100);   %intensity measurements are huge
            idx_tmp = idx_tmp+(idx~=0);     %cannot be zero, size that is
            idx = find(idx_tmp==3);     %find it, meet all criteria, done
            if size(idx,2)>1    %the wild case where the two made it through
                idx = 2;    %default only really works for me really
            end
        end
        
        %now find the outliers and remove the data
        %first calculate our criteria
        out = median(data_tmp(:,idx))+std(data_tmp(:,idx))*3;     %3 times the standard deviation should do it.
        [x,y] = find(data_tmp(:,idx)>out);        %find the outliers.
        data_tmp(x,:) = [];             %remove the outliers
        
        %do some math on the data
        cdata(1,:) = mean(data_tmp,1);
        cdata(2,:) = std(data_tmp,1);
        cdata(3,:) = repmat(size(data_tmp,1),1,size(data_tmp,2));
        cdata(4,:) = median(data_tmp,1);
        
        %localization for macs
        if ispc
            slash = '\';        %Windows directory marker
        else
            slash = '/';        %Mac directory marker
        end
        
        %now save the data
        csv_exp = dataset(cdata);               %to export as a CSV need to make the data a dataset.
        if all  %all output is named slightly differently
            export(csv_exp,'File',[dir_root,'asum_',name{i},'.csv'],'delimiter',',')
        else
            export(csv_exp,'File',[dir_root,'sum_',name{i},'.csv'],'delimiter',',')
        end
    end
end
